const { Sequelize, DataTypes } = require('sequelize');

const sequelize = new Sequelize('thilaka_old', 'root', '', {
  host: 'localhost',
  dialect: 'mysql' ,
  port:'3306'
});

const db={}
db.models = {};
db.sequelize=sequelize;
db.models.Invoicehed=require('../modules/invoicehed')(sequelize,Sequelize,DataTypes);
db.models.RootList=require('../modules/root_list')(sequelize,Sequelize,DataTypes);
db.models.JobCardDtl=require('../modules/jobcarddtl')(sequelize,Sequelize,DataTypes);
db.models.InvType=require('../modules/inv_type')(sequelize,Sequelize,DataTypes);
db.models.Customer=require('../modules/customer')(sequelize,Sequelize,DataTypes);
db.models.Users=require('../modules/users')(sequelize,Sequelize,DataTypes);
db.models.Invoice_hed=require('../modules/invoice_hed')(sequelize,Sequelize,DataTypes);
db.models.Accdetails=require('../modules/account_details')(sequelize,Sequelize,DataTypes);
db.models.Item_interest=require('../modules/item_interest')(sequelize,Sequelize,DataTypes);
db.models.Rental_Payment_Dtl=require('../modules/rental_payment_dtl')(sequelize,Sequelize,DataTypes);
db.models.Rental_Payid_Dtl=require('../modules/rental_paid_dtl')(sequelize,Sequelize,DataTypes);
db.models.RentalPaid=require('../modules/rental_paid')(sequelize,Sequelize,DataTypes);
db.models.Cards=require('../modules/cards')(sequelize,Sequelize,DataTypes);



db.models.Invoicehed.belongsTo(db.models.RootList, {
  foreignKey: 'InvRootNo', // foreign key in Invoicehed
  targetKey: 'id', // primary key in RootList

});

db.models.RootList.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvRootNo', // foreign key in Invoicehed
  sourceKey: 'id', // primary key in RootList

});

db.models.Invoicehed.belongsTo(db.models.InvType, {
  foreignKey: 'InvType', // foreign key in Invoicehed
  targetKey: 'invtype_id', // primary key in RootList

});


db.models.InvType.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvType', // foreign key in Invoicehed
  sourceKey: 'invtype_id', // primary key in RootList

});



db.models.Invoicehed.belongsTo(db.models.Customer, {
  foreignKey: 'InvCustomer', // foreign key in Invoicehed
  targetKey: 'CusCode', // primary key in RootList

});

db.models.Customer.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvCustomer', // foreign key in Invoicehed
  sourceKey: 'CusCode', // primary key in RootList

});


//users

db.models.Invoicehed.belongsTo(db.models.Users, {
  foreignKey: 'InvUser', // foreign key in Invoicehed
  targetKey: 'id', // primary key in RootList

});

db.models.Users.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvUser', // foreign key in Invoicehed
  sourceKey: 'id', // primary key in RootList

});


//invoice_hed


db.models.Invoice_hed.belongsTo(db.models.Users, {
  foreignKey: 'InvUser', // foreign key in Invoicehed
  targetKey: 'id', // primary key in RootList

});

db.models.Users.hasMany(db.models.Invoice_hed, {
  foreignKey: 'InvUser', // foreign key in Invoicehed
  sourceKey: 'id', // primary key in RootList

});

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
db.models.Invoicehed.belongsTo(db.models.RootList, {
  foreignKey: 'InvRootNo', // foreign key in Invoicehed
  targetKey: 'id', // primary key in RootList

});

db.models.RootList.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvRootNo', // foreign key in Invoicehed
  sourceKey: 'id', // primary key in RootList

});
*/

db.models.Invoice_hed.belongsTo(db.models.InvType, {
  foreignKey: 'InvType', // foreign key in Invoicehed
  targetKey: 'invtype_id', // primary key in RootList

});

db.models.InvType.hasMany(db.models.Invoice_hed, {
  foreignKey: 'InvType', // foreign key in Invoicehed
  sourceKey: 'invtype_id', // primary key in RootList

});

/*

db.models.Invoicehed.belongsTo(db.models.Customer, {
  foreignKey: 'InvCustomer', // foreign key in Invoicehed
  targetKey: 'CusCode', // primary key in RootList

});

db.models.Customer.hasMany(db.models.Invoicehed, {
  foreignKey: 'InvCustomer', // foreign key in Invoicehed
  sourceKey: 'CusCode', // primary key in RootList

});
*/

//users

db.models.Invoice_hed.belongsTo(db.models.Users, {
  foreignKey: 'InvUser', // foreign key in Invoicehed
  targetKey: 'id', // primary key in RootList

});

db.models.Users.hasMany(db.models.Invoice_hed, {
  foreignKey: 'InvUser', // foreign key in Invoicehed
  sourceKey: 'id', // primary key in RootList

});


//account details



db.models.Invoice_hed.belongsTo(db.models.Accdetails, {
  foreignKey: 'AccNo', // foreign key in Invoicehed
  targetKey: 'AccNo', // primary key in RootList

});

db.models.Accdetails.hasMany(db.models.Invoice_hed, {
  foreignKey: 'AccNo', // foreign key in Invoicehed
  sourceKey: 'AccNo', // primary key in RootList

});

//customer


db.models.Invoice_hed.belongsTo(db.models.Customer, {
  foreignKey: 'CusCode', // foreign key in Invoicehed
  targetKey: 'CusCode', // primary key in RootList

});

db.models.Customer.hasMany(db.models.Invoice_hed, {
  foreignKey: 'CusCode', // foreign key in Invoicehed
  sourceKey: 'CusCode', // primary key in RootList

});



db.models.Invoicehed.belongsTo(db.models.Item_interest, {
  foreignKey: 'InterestTerm', // foreign key in Invoicehed
  targetKey: 'IntTerm', // primary key in RootList

});

db.models.Item_interest.hasMany(db.models.Invoicehed, {
  foreignKey: 'InterestTerm', // foreign key in Invoicehed
  sourceKey: 'IntTerm', // primary key in RootList

});





module.exports=db;