const { Model, where, Sequelize, Op } = require('sequelize');
const { models: { Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails }, sequelize } = require('../config/DB_config');



module.exports = {

  GetAllCards: async (req, res) => {
    if (req.query.rootId) {
      let whereObj = { IsCancel: 0 }
      let cusWhere = { RootNo: req.query.rootId }
      let userWhere = {}
      const data = req.query.data;
      if (data === 'all') {
        whereObj = { IsCancel: 0 }
      } else if (data === 'due') {
        whereObj = { IsCancel: 0, TotalDue: { [Op.gt]: 0.0 }, }
      } else if (data === 'mobileNo') {
        cusWhere = { RootNo: req.query.rootId, MobileNo: req.query.cardNo }
      } else if (data === 'isComplete') {
        whereObj = { IsCancel: 0, IsComplete: { [Op.gt]: 0 }, }
      } else if (data === 'expired') {
        const today = new Date().toISOString().split('T')[0];
        whereObj = { IsCancel: 0, lastDate: { [Op.lt]: today }, }
      } else if (data === 'cardNo') {
        whereObj = { IsCancel: 0, AccNo: req.query.cardNo }
      } else if (data === 'cusName') {
        cusWhere = { RootNo: req.query.rootId, CusName:{[Op.like]: `%${req.query.cardNo}%`} }
      } else if (data === 'dueVal') {
        let due = parseInt(req.query.cardNo);
        console.log('due:' + due)
        whereObj = { IsCancel: 0, To1talDue: { [Op.gte]: due }, }
      } else if (data === 'fPay') {
        let fpayemntVal = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, firstPayment: fpayemntVal }
      } else if (data === 'lornWInst') {
        let total = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, TotalAmount: { [Op.gte]: total }, }
      } else if (data === 'paidVal') {
        let total = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, TotalPaid: { [Op.gte]: total }, }
      } else if (data === 'insVal') {
        let total = parseInt(req.query.cardNo);
        whereObj = { IsCancel: 0, Interest: { [Op.gte]: total }, }
      } else if (data === 'invoiceNo') {
        whereObj = { IsCancel: 0, InvNo: req.query.cardNo }

      } else if (data === 'userId') {
        whereObj = { IsCancel: 0, InvUser: req.query.cardNo }

      } else if (data === 'instTurm') {
        whereObj = { IsCancel: 0, InterestTerm: parseInt(req.query.cardNo) }
      } else if (data === 'date') {

        whereObj = {
          IsCancel: 0, [Op.and]: [
            sequelize.where(sequelize.fn('DATE', sequelize.col('lastDate')), req.query.cardNo)
          ]
        }
      } else if (data === 'cusCode') {
        cusWhere = { RootNo: req.query.rootId, CusCode:req.query.cardNo }
      }

 

      try {
        const data = await Invoice_hed.findAll({

          where: whereObj,

          include: [{
            model: InvType,
            required: true,

          }, {
            where: userWhere,
            attributes: ['username', 'id', 'role'],
            model: Users,
            required: true,
          }, {
            where: cusWhere,
            attributes: ['RootNo', 'CusCode', 'DisplayName', 'CusName', 'Nic','MobileNo'],
            model: Customer,
            required: true,
          },
          ],
        });

        
        res.json(data)
      } catch (error) {
        console.log(error);
        res.send(error)
      }


    } else {
      res.status(500).json({
        msg: 'no root id'
      })
    }
  }
}