const { Model, where, Sequelize, Op } = require('sequelize');

const { models: { Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails, Item_interest, Rental_Payment_Dtl, Rental_Payid_Dtl }, sequelize } = require('../config/DB_config');
const rental_paid_dtl = require('../modules/rental_paid_dtl');
const { response } = require('express');




module.exports = {

  SAVE_RENTAL_PAID_DTL: async (req, res) => {
    console.log('SAVE_RENTAL_PAID_DTL');
    if (req.paymentId) {
      const paymentId = req.paymentId;
      const {
        paymentType, payDate, invNo, cusCode, checkRecDate, checkDate, CheckRef,
        payAmount, settleAmount, invoiceClose, checkNo, cashAmount, checkAmount,
        insAmount, invDate, accNo, saleParsan, allInst
      } = req.body;

      if (paymentId && paymentType && payDate && invNo && cusCode && payAmount && settleAmount &&
        invoiceClose && cashAmount && insAmount && invDate && accNo && saleParsan && allInst) {

        try {
          let canComplete = 0;
          let balance = Number(payAmount); // Ensure payAmount is a valid number
          if (isNaN(balance)) {
            throw new Error("Invalid payAmount value. Must be a number.");
          }

          const lastDate = await getLastPaid(invNo); // Await if async
          let iterations = 0;
          const maxIterations = 1000;




          while (balance > 0 && iterations < maxIterations) {
            console.log('payment');
            const payed = await Rental_Payment_Dtl.count({
              where: { InvNo: invNo, IsPaid: 1 }
            });
            const nextPaymonth = payed + 1;

            if (payed < allInst) {
              const monthPayment = await Rental_Payment_Dtl.findOne({
                where: { InvNo: invNo, Month: nextPaymonth }
              });

              if (!monthPayment) {
                console.error('No payment data found for nextPaymonth.');
                break;
              }

              const arlySettled = monthPayment.SettleAmount;
              const monthInst = monthPayment.MonPayment;
              const balanceAmount = monthInst - arlySettled;

              console.log('arlySettled', arlySettled);
              console.log('monthInst', monthInst);
              console.log('balanceAmount', balanceAmount);

              if (balance >= balanceAmount) {

                await Rental_Payment_Dtl.update(
                  { SettleAmount: monthInst, IsPaid: 1 },
                  {
                    where: {
                      AccNo: monthPayment.AccNo,
                      InvNo: monthPayment.InvNo,
                      Month: monthPayment.Month
                    }
                  }
                );

                await Rental_Payid_Dtl.create({
                  PaymentId: paymentId,
                  PaymentType: paymentType,
                  PayAmount: balanceAmount,
                  InvNo: monthPayment.InvNo,
                  AccNo: monthPayment.AccNo,
                  Month: monthPayment.Month,
                });

                updateInvoiceHed(invNo, balance);
                balance -= balanceAmount;
                console.log('Updated balance:', balance);
              } else {

                const newSettleAmount = parseInt(arlySettled) + parseInt(balance);

                await Rental_Payment_Dtl.update(
                  { SettleAmount: newSettleAmount, IsPaid: 0 },
                  {
                    where: {
                      AccNo: monthPayment.AccNo,
                      InvNo: monthPayment.InvNo,
                      Month: monthPayment.Month
                    }
                  }
                );

                await Rental_Payid_Dtl.create({
                  PaymentId: paymentId,
                  PaymentType: paymentType,
                  PayAmount: balance,
                  InvNo: monthPayment.InvNo,
                  AccNo: monthPayment.AccNo,
                  Month: monthPayment.Month,
                });

                updateInvoiceHed(invNo, balance);
                balance = 0; // All balance consumed
                console.log('Updated balance:', balance);
              }
            } else {
              console.log('All installments paid.');
              break;
            }
          }

          res.send("Data saved successfully.");
        } catch (error) {
          console.error('Error during processing:', error.message);
          res.status(500).send("An error occurred while saving data.");
        }
      } else {
        res.status(400).send("Invalid request data.");
      }
    } else {
      res.status(400).send('Payment ID not found.');
    }
  }



}



// Example usage



async function updateInvoiceHed(invoiceNo, balance) {
  try {


    const invHed = await Invoice_hed.findOne({

      where: { InvNo: invoiceNo }
    });
    console.log('invHed', invHed);
    if (parseInt(invHed.TotalPaid) === 0) {

      try {
        await Invoice_hed.update(
          { TotalPaid: parseInt(balance), TotalDue: parseInt(invHed.FinalAmount) - parseInt(balance), firstPayment: parseInt(balance) },
          {
            where: {

              InvNo: invoiceNo,

            }
          },
        )
      } catch (error) {
        console.error(error)
      }
    } else if (parseInt(invHed.TotalPaid) + parseInt(balance) >= invHed.FinalAmount) {
      try {
        await Invoice_hed.update(
          { TotalPaid: parseInt(invHed.TotalPaid) + parseInt(balance), TotalDue: parseInt(invHed.TotalDue) - parseInt(balance), IsComplete: 1 },
          {
            where: {

              InvNo: invoiceNo,

            }
          },
        )
      } catch (error) {
        console.error(error)
      }
    } else if (parseInt(invHed.TotalPaid) + parseInt(balance) < invHed.FinalAmount) {

      try {
        await Invoice_hed.update(
          { TotalPaid: parseInt(invHed.TotalPaid) + parseInt(balance), TotalDue: parseInt(invHed.TotalDue) - parseInt(balance) },
          {
            where: {

              InvNo: invoiceNo,

            }
          },
        )
      } catch (error) {
        console.error(error)
      }

    }

  } catch (error) {
    console.log(error)
  }
}



async function getLastPaid(invNo) {
  console.log('last paid', invNo)

  try {
    const invHed = await Invoice_hed.findOne({
      attributes: ['lastDate'],

      where: { InvNo: invNo }
    })
    console.log('data : ', invHed.lastDate)
    return (invHed.lastDate)







  } catch (error) {
    console.log(error)
  }
}