const { Model, where, Sequelize, Op } = require('sequelize');
const { models: { Invoicehed, RootList, JobCardDtl, InvType, Customer, Users, Invoice_hed, Accdetails, RentalPaid }, sequelize } = require('../config/DB_config');



const getLastPaymentID = async (req, res, next) => {

    console.log('getLastPaymentID');
    try {
        getLastRecord().then(record => {
            if (record) {
                const paymentId = incrementPaymentId(record.PaymentId);
                req.paymentId = paymentId;


                next();
            } else {
                res.send("No records found.");
            }
        });





        // Pass control to the next handler
    } catch (error) {
        res.status(500).send("An error occurred while saving data.");
    }
};


const getLastRecord = async () => {
   
    try {
        const lastRecord = await RentalPaid.findOne({
            attributes: ['PaymentId'],
            order: [
                [sequelize.literal("CAST(REPLACE(PaymentId, 'LP', '') AS SIGNED)"), 'DESC']
            ]
        });
console.log('lastRecord',lastRecord)
        return lastRecord;
    } catch (error) {
        console.error("Error fetching the last record:", error);
        res.status(500).send("An error occurred while saving data.");
    }
};




const saveRentalPaid = async (req, res, next) => {
    console.log('saveRentalPaid');
  
    if (req.paymentId) {
        const paymentId = req.paymentId;
        try {
            const { paymentType, payDate, invNo, cusCode, checkRecDate, checkDate, CheckRef, payAmount, settleAmount, invoiceClose, checkNo, cashAmount, checkAmount, insAmount, invDate, accNo, saleParsan } = req.body;
            const OverPayAmount = 0;
            const overPayInv = 0;
            const exAmount = 0.0;
            if (paymentId, paymentType, payDate, invNo, cusCode, payAmount, settleAmount, invoiceClose, cashAmount, OverPayAmount, overPayInv, exAmount, insAmount, invDate, accNo, saleParsan) {


                try {
                    const parameters = {
                        P_PaymentId: req.paymentId,
                        P_PaymentType: req.body.paymentType,
                        P_PayDate: req.body.payDate,
                        P_InvNo: req.body.invNo,
                        P_CusCode: req.body.cusCode,
                        P_ChequeRecDate: '',
                        P_ChequeDate: '',
                        P_ChequeReference: '',
                        P_PayAmount: req.body.payAmount,
                        P_SettleAmount: req.body.settleAmount,
                        P_InvoiceColse: req.body.invoiceClose,
                        P_ChequeNo: '',
                        P_CashAmount: req.body.cashAmount,
                        P_ChequeAmount: 0,
                        P_Over_PayAmount: 0.00,
                        P_Over_PayInv: '',
                        P_ExAmount: req.body.exAmount,
                        P_InsAmount: req.body.insAmount,
                        P_InvDate: req.body.invDate,
                        P_AccNo: req.body.accNo,
                    };

                    const result = await sequelize.query(
                        `CALL SPT_SAVE_RENTAL_PAID(
                        :P_PaymentId, :P_PaymentType, :P_PayDate, :P_InvNo, :P_CusCode, :P_ChequeRecDate, 
                        :P_ChequeDate, :P_ChequeReference, :P_PayAmount, :P_SettleAmount, :P_InvoiceColse, 
                        :P_ChequeNo, :P_CashAmount, :P_ChequeAmount, :P_Over_PayAmount, :P_Over_PayInv, 
                        :P_ExAmount, :P_InsAmount, :P_InvDate, :P_AccNo
                    )`, // Removed trailing comma here
                        {
                            replacements: parameters,
                            type: sequelize.QueryTypes.RAW
                        }
                    );

                    next(); // Make sure this is placed correctly and does not return prematurely
                } catch (error) {
                    console.error(error);
                    res.status(500).send("An error occurred while saving data.");
                }


            } else {
                console.log(error);
                res.status(500).send("An error occurred while saving data.");
            }


        } catch (error) {
            console.log(error);
            res.status(500).send("An error occurred while saving data.");
        }
    } else {
        res.send('payment id not found')
    }
}
function incrementPaymentId(paymentId) {
    console.log('incrementPaymentId');
    const prefix = paymentId.slice(0, 2);
    const numberPart = parseInt(paymentId.slice(2));

    const incrementedNumber = numberPart + 1;


    const newNumberPart = incrementedNumber.toString().padStart(paymentId.length - 2, '0');

    return prefix + newNumberPart;
}
module.exports = { getLastPaymentID, saveRentalPaid };