const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const AccDetails = sequelize.define('account_details',{

        AccId: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        AccNo: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },     
        CusCode: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        AccDate: {
            type: DataTypes.DATE,
            allowNull: true,
        
        },
        AccType: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        ItemCategory: {
            type: DataTypes.INTEGER,
            allowNull: false,
        
        },
        CusNic: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        Location: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        Remark: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        InvUser: {
            type: DataTypes.INTEGER,
            allowNull: true,
        
        },
        IsCreate: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },
        refNo: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        salePerson: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        collector: {
            type: DataTypes.STRING,
            allowNull: false,
        
        }
    },{
        tableName: 'account_details', 
        freezeTableName: true,
        timestamps: false,      
    }
   );
    return AccDetails;
    
};





