const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const Customer = sequelize.define('customer',{

        CusCode: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        OldCode: {
            type: DataTypes.BIGINT,
            allowNull: true,
        
        },     
        CusBookNo: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        DisType: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },
        RespectSign: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        CusName: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        DisplayName: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        LastName: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        JoinDate: {
            type: DataTypes.DATE,
            allowNull: true,
        
        },
        RootNo: {
            type: DataTypes.SMALLINT,
            allowNull: true,
        
        },
        Address01: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        Address02: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        Address03: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        ComAddress: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        MobileNo: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        LanLineNo: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },Fax: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        Email: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        IsAllowCredit: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        CreditLimit: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        
        },
        CreditPeriod: {
            type: DataTypes.SMALLINT,
            allowNull: false,
        
        },
        IsLoyalty: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        LoyaltyNo: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        IsVat: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },VatNumber: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        ContactPerson: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        ContactNo: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        IsActive: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },
        Flag: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        BalanceDate: {
            type: DataTypes.DATE,
            allowNull: false,
        
        },
        BalanaceAmount: {
            type: DataTypes.DECIMAL,
            allowNull: false,
        
        },
        payMethod: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },
        CusType: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },
        CusCompany: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        DocNo: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        HandelBy: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        CusCategory: {
            type: DataTypes.STRING,
            allowNull: true,
        
        },
        remark: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        IsSyn: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        IsDelete: {
            type: DataTypes.TINYINT,
            allowNull: true,
        
        },
        CusType_easy: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        IsEasy: {
            type: DataTypes.TINYINT,
            allowNull: false,
        
        },
        Nic: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
       
    },{
        tableName: 'customer', 
        freezeTableName: true,
        timestamps: false,      
    }
   );
    return Customer;
    
};





