const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
const RentalPaid = sequelize.define('rental_paid', {
  PaymentId: {
    type: DataTypes.STRING(20),
    allowNull: false,
    primaryKey: true,
  },
  PaymentType: {
    type: DataTypes.INTEGER(1),
    allowNull: false,
    defaultValue: 0,
    primaryKey: true,
  },
  TotalPayment: {
    type: DataTypes.DECIMAL(20, 2),
    allowNull: true,
  },
  CashPayment: {
    type: DataTypes.DECIMAL(20, 2),
    allowNull: true,
  },
  ChequePayment: {
    type: DataTypes.DECIMAL(20, 2),
    allowNull: true,
  },
  PayAmount: {
    type: DataTypes.DECIMAL(20, 2),
    allowNull: true,
  },
  AccNo: {
    type: DataTypes.STRING(20),
    allowNull: true,
  },
  InvNo: {
    type: DataTypes.STRING(20),
    allowNull: false,
    defaultValue: '',
    primaryKey: true,
  },
  CusCode: {
    type: DataTypes.STRING(10),
    allowNull: true,
  },
  PayDate: {
    type: DataTypes.DATE,
    allowNull: true,
  },
  ChequeNo: {
    type: DataTypes.STRING(50),
    allowNull: true,
  },
  ChequeRecDate: {
    type: DataTypes.DATEONLY,
    allowNull: true,
  },
  ChequeDate: {
    type: DataTypes.DATEONLY,
    allowNull: true,
  },
  ChequeReference: {
    type: DataTypes.STRING(100),
    allowNull: true,
  },
  ExtraAmount: {
    type: DataTypes.DECIMAL(20, 2),
    allowNull: true,
  },
  InsuranceAmount: {
    type: DataTypes.DECIMAL(20, 2),
    allowNull: true,
  },
  InvDate: {
    type: DataTypes.DATE,
    allowNull: true,
  },
  IsCancel: {
    type: DataTypes.TINYINT(1),
    allowNull: true,
    defaultValue: 0,
  },
 
}, {
  tableName: 'rental_paid',
  timestamps: false,
  charset: 'latin1',
  collate: 'latin1_general_ci',
});

return RentalPaid;

}
