const { DataTypes, sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const Users = sequelize.define('users',{

        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        ip_address: {
            type: DataTypes.STRING,
            allowNull: false,
        
        },
        username: {
            type: DataTypes.STRING,
            allowNull: false
        },
        password: {
            type: DataTypes.STRING,
            allowNull: false
        },
        salt: {
            type: DataTypes.STRING,
            allowNull: true
        }, email: {
            type: DataTypes.STRING,
            allowNull: false
        },activation_code: {
            type: DataTypes.STRING,
            allowNull: true
        },forgotten_password_code: {
            type: DataTypes.STRING,
            allowNull: true
        },forgotten_password_time: {
            type: DataTypes.INTEGER,
            allowNull: true
        },remember_code: {
            type: DataTypes.STRING,
            allowNull: true
        },created_on: {
            type: DataTypes.INTEGER,
            allowNull: false
        },last_login: {
            type: DataTypes.INTEGER,
            allowNull: true,
            
        },active: {
            type: DataTypes.TINYINT,
            allowNull: true
        },first_name: {
            type: DataTypes.STRING,
            allowNull: true
        },last_name: {
            type: DataTypes.STRING,
            allowNull: true
        },company: {
            type: DataTypes.STRING,
            allowNull: true
        },phone: {
            type: DataTypes.STRING,
            allowNull: true
        },location: {
            type: DataTypes.TINYINT,
            allowNull: true
        },com_id: {
            type: DataTypes.TINYINT,
            allowNull: true
        },role: {
            type: DataTypes.TINYINT,
            allowNull: true
        }
    },{
        tableName: 'users', 
        freezeTableName: true,
        timestamps: false,      
    }
   );
    return Users;
    
};





